#include <amxmodx>
#include <amxmisc>
#include <engine>
#include <fakemeta>
#include <hamsandwich>
#include <fun>
#include <cstrike>

#define PLUGIN "Meat Day"
#define VERSION "1.1"
#define AUTHOR "Tracker"

#define MAXPLAYERS            32


new bool: g_Chain[33], start[33]

new const g_chain_viewmodel[] = { "models/JailShop/v_moto.mdl" };
new const g_chain_weaponmodel[] = { "models/JailShop/p_moto.mdl" };

public plugin_init() {

register_plugin(PLUGIN, VERSION, AUTHOR)

register_clcmd("meat", "cmd_start")

	register_event( "CurWeapon", "WeaponChange", "be", "1=1" )
	register_forward(FM_EmitSound, "fw_EmitSound")
	RegisterHam(Ham_Spawn, "player", "Spawn_player", 1)
	RegisterHam(Ham_TakeDamage, "player", "TakeDamage")
	register_clcmd("drop","cmd_drop")
	register_logevent("round_start", 2, "0=World triggered", "1=Round_Start")
	register_logevent("round_start", 2, "0=World triggered", "1&Restart_Round_");
	register_logevent("round_start", 2, "0=World triggered", "1=Game_Commencing");
	register_logevent("round_end", 2, "1=Round_End");
}
public plugin_precache()
{
	precache_model( "models/JailShop/p_moto.mdl" )
	precache_model( "models/JailShop/v_moto.mdl" )
	precache_sound( "JailShop/MTSlash.wav" )
	precache_sound( "JailShop/MTConvoca.wav" )
	precache_sound( "JailShop/MTHitWall.wav" )
	precache_sound( "JailShop/MTHit2.wav" )
	precache_sound( "JailShop/MTStab.wav" )
	precache_sound( "JailShop/ESlash.wav" )
	
}


public started()
{
    for(new i = 0; i <= MAXPLAYERS; i++)
    {
			
		if (is_user_alive(i) && cs_get_user_team(i) == CS_TEAM_CT) 
		{
		
		    new iDgl = give_item( i, "weapon_m249" );
			
				give_item( i, "weapon_m249" );
                cs_set_weapon_ammo( iDgl, 900 );
                cs_set_user_bpammo( i, CSW_M249, 0);
				set_user_health(i,400)
		}
		else
		{
			if (is_user_alive(i) && cs_get_user_team(i) == CS_TEAM_T) 
			{
				give_item( i, "weapon_knife" )
				set_pev(i, pev_viewmodel2, g_chain_viewmodel)
				set_pev(i, pev_weaponmodel2, g_chain_weaponmodel)
				set_user_health(i,1500)
				g_Chain[i] = true
			}
		}
		set_task(1.0, "check_weapon", i, _, _, "b");
	}
}

public cmd_start(id)

{	
	if (get_user_flags(id) & ADMIN_LEVEL_G)
	{
		if (start[id]) return PLUGIN_HANDLED
		else 
		{
			for(new i = 1; i <= MAXPLAYERS; i++)

			if (is_user_alive(i)) strip_user_weapons(i)
			started()
			start[id] = true;
		}
	}

	return PLUGIN_HANDLED
}
public WeaponChange(id)
{
	static weapon;
	weapon = read_data(2);
	
	if (weapon == CSW_KNIFE && g_Chain[id])
	{
		set_pev(id, pev_viewmodel2, g_chain_viewmodel)
		set_pev(id, pev_weaponmodel2, g_chain_weaponmodel)
	}
}

public TakeDamage(victim, inflictor, attacker, Float:damage, damage_type)
{
	if (victim == attacker || !is_user_connected(attacker))
		return HAM_IGNORED;
	
		
	if (get_user_weapon(attacker) == CSW_KNIFE && g_Chain[attacker])
	{
		SetHamParamFloat(4, 70.0)
	}
	
	return HAM_IGNORED
}

public fw_EmitSound(id, channel, const sample[], Float:volume, Float:attn, flags, pitch)
{
		if (!is_user_connected(id))
		return FMRES_IGNORED;
		
	if (g_Chain[id] && equal(sample[8], "kni", 3))
	{

		volume = 0.6;
		
		if (equal(sample[14], "sla", 3))
		{
			engfunc(EngFunc_EmitSound, id, channel, "JailShop/MTSlash.wav", volume, attn, flags, pitch);
			return FMRES_SUPERCEDE;
		}
		if(equal(sample,"weapons/knife_deploy1.wav"))
		{
			engfunc(EngFunc_EmitSound, id, channel, "JailShop/MTConvoca.wav", volume, attn, flags, pitch);
			return FMRES_SUPERCEDE;
		}
		if (equal(sample[14], "hit", 3))
		{
			if (sample[17] == 'w') 
			{
				engfunc(EngFunc_EmitSound, id, channel,"JailShop/MTHitWall.wav", volume, attn, flags, pitch);
				return FMRES_SUPERCEDE;
			}
			else 
			{
				engfunc(EngFunc_EmitSound, id, channel, "JailShop/MTHit2.wav", volume, attn, flags, pitch);
				return FMRES_SUPERCEDE;
			}
		}
		if (equal(sample[14], "sta", 3)) 
		{
			engfunc(EngFunc_EmitSound, id, channel, "JailShop/MTStab.wav", volume, attn, flags, pitch);
			return FMRES_SUPERCEDE;
		}
	}

	return FMRES_IGNORED;
}

public Spawn_player(id)
{
if (start[id])
{
	if (is_user_alive(id) && cs_get_user_team(id) == CS_TEAM_CT) 
	{
		strip_user_weapons(id)
	    new iDgl = give_item( id, "weapon_m249" );
		
			give_item( id, "weapon_m249" );
               cs_set_weapon_ammo( iDgl, 900 );
               cs_set_user_bpammo( id, CSW_M249, 0);
			set_user_health(id,700)
	}
	else
	{
		if (is_user_alive(id) && cs_get_user_team(id) == CS_TEAM_T) 
		{
			strip_user_weapons(id)
			give_item( id, "weapon_knife" )
			set_pev(id, pev_viewmodel2, g_chain_viewmodel)
			set_pev(id, pev_weaponmodel2, g_chain_weaponmodel)
			set_user_health(id,1500)
			g_Chain[id] = true
		}
	}
}
else return;
}
public check_weapon(id)
{
		if (is_user_alive(id) && cs_get_user_team(id) == CS_TEAM_CT && get_user_weapon(id) != CSW_M249) 
		{
			strip_user_weapons(id)
		    new iDgl = give_item( id, "weapon_m249" );
			
			give_item( id, "weapon_m249" )
            cs_set_weapon_ammo( iDgl, 900 );
            cs_set_user_bpammo( id, CSW_M249, 0);
		}
		else
		{
			if (is_user_alive(id) && cs_get_user_team(id) == CS_TEAM_T && get_user_weapon(id) != CSW_KNIFE) 
			{
				strip_user_weapons(id)
				give_item( id, "weapon_knife" )
			}
		}
}

public cmd_drop(id)
{
	if (start[id]) return PLUGIN_HANDLED
	return PLUGIN_CONTINUE
}
public round_start()
{
	for(new i = 0; i <= MAXPLAYERS; i++)
	{
		g_Chain[i] = false
		start[i] = false
		remove_task( i , _ );
	}
}
public round_end()
{
	for(new i = 0; i <= MAXPLAYERS; i++)
	{
		g_Chain[i] = false
		start[i] = false
		remove_task( i , _ );
		if(is_user_alive(i)) strip_user_weapons(i)
	
	}
}